//Fragment Shader adapted ~The Cave by BoyC~ MsX3RH of Shadertoy.com. 
//made compatible with VGHD player by ET using several code tweeks inspired
//by @TheEmu (as below ///) and rehashing of some of the syntax & terminology conventions.
//via ETModGo1 remix. See comments below.

// Use defines here rather than edit the body of the code.
#define iMouse AUTO_MOUSE
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract
#define iGlobalTime u_Elapsed 
#define iResolution u_WindowSize 
/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

#define fragCoord gl_FragCoord
#define tex0 sampler2D
/////////////////////////////////////////////////////////////////////////////////
#ifdef GL_ES
precision highp float;
#endif
/////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////
//float time=iGlobalTime/3.0+291.0;//+43.63/3.0;
float time=iGlobalTime/20.37+43.63; // lowered travel pace forward to suit model animations~ET

#define PI 			3.14159265359

#define FOV 		60.0
#define EPSILON		0.001
#define MAX_STEPS	1000
#define MAX_DIST	1000.0

#define PLANE		vec4 (0.0, 1.0, 0.0, 1.0)
#define BOTTOM		vec4 (0.0, 1.0, 0.0, 4.0)

vec4 texture3D (sampler2D tex, vec3 pt, vec3 pn, float scale) {
	return 
		texture2D (tex, pt.xy/scale) * abs (pn.z) +
		texture2D (tex, pt.xz/scale) * abs (pn.y) +
		texture2D (tex, pt.zy/scale) * abs (pn.x);
}

mat3 rotate_x (float fi) {
	float cfi = cos (fi);
	float sfi = sin (fi);
	return mat3 (
		1.0, 0.0, 0.0,
		0.0, cfi, -sfi,
		0.0, sfi, cfi);
}

mat3 rotate_y (float fi) {
	float cfi = cos (fi);
	float sfi = sin (fi);
	return mat3 (
		cfi, 0.0, sfi,
		0.0, 1.0, 0.0,
		-sfi, 0.0, cfi);
}

mat3 rotate_z (float fi) {
	float cfi = cos (fi);
	float sfi = sin (fi);
	return mat3 (
		cfi, -sfi, 0.0,
		sfi, cfi, 0.0,
		0.0, 0.0, 1.0);
}

vec4 noise3v (vec2 p) {
	return texture2D (iChannel3, p);
}

vec4 fbm3v (vec2 p) {
	vec4 f = vec4 (0.0);
	f += (vec4 (0.5000) * noise3v (p)); p *= vec2 (2.01);
	f += (vec4 (0.2500) * noise3v (p)); p *= vec2 (2.02);
	f += (vec4 (0.1250) * noise3v (p)); p *= vec2 (2.03);
	f += (vec4 (0.0625) * noise3v (p)); p *= vec2 (2.04);
	f /= vec4 (0.9375);
	return f;
}

float dplane (vec3 pt, vec4 pl) {
	return dot (pl.xyz, pt) + pl.w;
}	

float map (vec3 pt) {
	return dplane (pt, PLANE);
}

float map2 (vec3 pt) {
	return dplane (pt, BOTTOM);
}

float march (vec3 ro, vec3 rd) {
	float t = 0.0;
	float d = 0.0;
	vec3 pt = vec3 (0.0);
	for (int i = 0; i < MAX_STEPS; ++i) {
		pt = ro + rd * t;
		d = map (pt); 
		if (d < EPSILON || t + d >= MAX_DIST) {			
			break;
		}
		t += d;
	}
	
	return d <= EPSILON ? t : MAX_DIST;
}

float march2 (vec3 ro, vec3 rd) {
	float t = 0.0;
	float d = 0.0;
	vec3 pt = vec3 (0.0);
	for (int i = 0; i < MAX_STEPS; ++i) {
		pt = ro + rd * t;
		d = map2 (pt); 
		if (d < EPSILON || t + d >= MAX_DIST) {			
			break;
		}
		t += d;
	}
	
	return d <= EPSILON ? t : MAX_DIST;
}

float fresnel_step (vec3 I, vec3 N, vec3 f) {
	return clamp (f.x + f.y * pow (1.0 + dot (I, N), f.z), 0.0, 1.0);
}


void mainImage( out vec4 fragColor, in vec2 fragCoord ) {
	vec2 uv = (2.0*fragCoord.xy - iResolution.xy)/min (iResolution.x, iResolution.y) * tan (radians (FOV)/2.0);
	vec2 mo = PI * iMouse.xy / iResolution.xy;
	
	mat3 rt = rotate_y (mo.x * PI);
	
	vec3 up = vec3 (0.0, 1.0, 0.0) ;			// up 
	vec3 fw = vec3 (0.0, 0.0, 1.0) *rt;			// forward
	vec3 lf = cross (up, fw); 					// left
	
	vec3 ro = -fw * 5.0 + vec3 (0.0, 5.0, 0.0); // ray origin
	vec3 rd = normalize (uv.x * lf + uv.y * up + fw) ; 		// ray direction
	
	float t = march (ro, rd);
	vec4 cm = textureCube (iChannel0, rd);
	vec3 pt = rd*t + ro;
	vec3 pn = PLANE.xyz;
	vec3 dv = fbm3v (pt.xz/512.0+iGlobalTime/512.0).xyz-0.5;
	pn = normalize (pn + dv*0.2);
	vec3 rfl = reflect (rd, pn);
	float fs = fresnel_step (rd, pn, vec3 (0.0, 3.0, 6.0));
	vec4 c0 = textureCube (iChannel0, rfl);
	vec4 c1 = textureCube (iChannel0, normalize (rd+dv*0.1));

	gl_fragColor = mix (mix (
		c0,
		c1,			
		1.0 - fs), cm, smoothstep (80.0, 160.0, t));
	
}		